package org.example;

public class Main {

    public static int factorial(int n) {
        if (n <= 1) {
            return 1;
        }
        return n * factorial(n - 1);
    }

    public static int factorialIterative(int n) {
        int result = 1;
        for (int i = 1; i <= n; i++) {
            result *= i;
        }
        return result;
    }
    public static int factorialTailRecursive(int n) {
        return factorialTailRecursiveHelper(n, 1);
    }

    private static int factorialTailRecursiveHelper(int n, int accumulator) {
        if (n <= 1) {
            return accumulator;
        }
        return factorialTailRecursiveHelper(n - 1, n * accumulator);
    }


    public static void main(String[] args) {
        int result = factorial(5);
        System.out.println("Factorial: " + result);

        int result1 = factorialIterative(5);
        System.out.println("Factorial Iterative: " + result1);

        int result2 = factorialTailRecursive(5);
        System.out.println("Factorial Tail Recursive: " + result2);

    }

}